/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;

public class ChunkCache {
    private static final int MAX_CHUNKS_PER_DIMENSION = 4096;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, LRUCache<class_1923, byte[]>> dimensionCaches = new ConcurrentHashMap<String, LRUCache<class_1923, byte[]>>();
    private final Path cacheDirectory;

    public ChunkCache(Path minecraftDir) {
        this.cacheDirectory = minecraftDir.resolve("minimap_cache");
        try {
            Files.createDirectories(this.cacheDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Erreur lors de la cr\u00e9ation du dossier de cache : " + e.getMessage());
        }
    }

    private LRUCache<class_1923, byte[]> getCacheForDimension(String dimensionId) {
        return this.dimensionCaches.computeIfAbsent(dimensionId, id -> new LRUCache(4096));
    }

    public void putChunk(String dimensionId, int chunkX, int chunkZ, byte[] colorData) {
        class_1923 pos = new class_1923(chunkX, chunkZ);
        this.getCacheForDimension(dimensionId).put(pos, colorData);
    }

    public byte[] getChunk(String dimensionId, int chunkX, int chunkZ) {
        class_1923 pos = new class_1923(chunkX, chunkZ);
        return (byte[])this.getCacheForDimension(dimensionId).get(pos);
    }

    public boolean hasChunk(String dimensionId, int chunkX, int chunkZ) {
        class_1923 pos = new class_1923(chunkX, chunkZ);
        return this.getCacheForDimension(dimensionId).containsKey(pos);
    }

    public Map<class_1923, byte[]> getAllChunks(String dimensionId) {
        LRUCache<class_1923, byte[]> cache = this.dimensionCaches.get(dimensionId);
        if (cache == null) {
            return Collections.emptyMap();
        }
        return new HashMap<class_1923, byte[]>(cache.getAll());
    }

    public int getChunkCount(String dimensionId) {
        LRUCache<class_1923, byte[]> cache = this.dimensionCaches.get(dimensionId);
        return cache != null ? cache.size() : 0;
    }

    public void saveDimensionCache(String dimensionId) {
        LRUCache<class_1923, byte[]> cache = this.dimensionCaches.get(dimensionId);
        if (cache == null || cache.isEmpty()) {
            return;
        }
        try {
            Path file = this.cacheDirectory.resolve(this.sanitizeDimensionId(dimensionId) + ".cache");
            try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));){
                dos.writeInt(1);
                dos.writeInt(cache.size());
                for (Map.Entry<class_1923, byte[]> entry : cache.getAll().entrySet()) {
                    class_1923 pos = entry.getKey();
                    byte[] data = entry.getValue();
                    dos.writeInt(pos.field_9181);
                    dos.writeInt(pos.field_9180);
                    dos.write(data);
                }
            }
            System.out.println("Cache sauvegard\u00e9 : " + dimensionId + " (" + cache.size() + " chunks)");
        }
        catch (IOException e) {
            System.err.println("Erreur lors de la sauvegarde du cache : " + e.getMessage());
        }
    }

    public void loadDimensionCache(String dimensionId) {
        try {
            Path file = this.cacheDirectory.resolve(this.sanitizeDimensionId(dimensionId) + ".cache");
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            try (DataInputStream dis = new DataInputStream(new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));){
                int version = dis.readInt();
                if (version != 1) {
                    System.err.println("Version de cache non support\u00e9e : " + version);
                    return;
                }
                int chunkCount = dis.readInt();
                LRUCache<class_1923, byte[]> cache = this.getCacheForDimension(dimensionId);
                for (int i = 0; i < chunkCount; ++i) {
                    int x = dis.readInt();
                    int z = dis.readInt();
                    byte[] data = new byte[256];
                    int read = dis.read(data);
                    if (read != 256) continue;
                    cache.put(new class_1923(x, z), data);
                }
                System.out.println("Cache charg\u00e9 : " + dimensionId + " (" + chunkCount + " chunks)");
            }
        }
        catch (IOException e) {
            System.err.println("Erreur lors du chargement du cache : " + e.getMessage());
        }
    }

    public void saveAll() {
        for (String dimensionId : this.dimensionCaches.keySet()) {
            this.saveDimensionCache(dimensionId);
        }
    }

    public void loadAll() {
        try {
            Files.list(this.cacheDirectory).filter(path -> path.toString().endsWith(".cache")).forEach(path -> {
                String fileName = path.getFileName().toString();
                String dimensionId = fileName.replace(".cache", "");
                this.loadDimensionCache(dimensionId);
            });
        }
        catch (IOException e) {
            System.err.println("Erreur lors du chargement des caches : " + e.getMessage());
        }
    }

    public void clearDimension(String dimensionId) {
        this.dimensionCaches.remove(dimensionId);
    }

    private String sanitizeDimensionId(String dimensionId) {
        return dimensionId.replace(":", "_").replace("/", "_");
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public LRUCache(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        public Map<K, V> getAll() {
            return new HashMap(this);
        }
    }
}

