/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_310;

public class MinimapState {
    public static final MinimapState INSTANCE = new MinimapState();
    private boolean minimapVisible = true;
    private float zoomLevel = 1.0f;
    private int caveLevel = -1;
    private final Map<UUID, PlayerData> players = new ConcurrentHashMap<UUID, PlayerData>();
    private boolean isLoadingChunks = false;
    private int loadedChunks = 0;
    private int totalChunks = 0;

    private MinimapState() {
    }

    public boolean isMinimapVisible() {
        return this.minimapVisible;
    }

    public void setMinimapVisible(boolean visible) {
        this.minimapVisible = visible;
    }

    public void toggleMinimapVisible() {
        this.minimapVisible = !this.minimapVisible;
    }

    public float getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(float zoom) {
        this.zoomLevel = Math.max(0.5f, Math.min(4.0f, zoom));
    }

    public void zoomIn() {
        this.setZoomLevel(this.zoomLevel + 0.25f);
    }

    public void zoomOut() {
        this.setZoomLevel(this.zoomLevel - 0.25f);
    }

    public int getCaveLevel() {
        return this.caveLevel;
    }

    public void setCaveLevel(int level) {
        this.caveLevel = level;
    }

    public boolean isCaveModeEnabled() {
        return this.caveLevel >= 0;
    }

    public void increaseCaveLevel() {
        if (this.caveLevel == -1) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                this.caveLevel = (int)client.field_1724.method_23318();
            }
        } else {
            ++this.caveLevel;
        }
    }

    public void decreaseCaveLevel() {
        if (this.caveLevel == -1) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                this.caveLevel = (int)client.field_1724.method_23318();
            }
        } else {
            --this.caveLevel;
        }
    }

    public void disableCaveMode() {
        this.caveLevel = -1;
    }

    public void updatePlayer(UUID uuid, String name, double x, double y, double z, String dimension, double health, double maxHealth, float yaw) {
        PlayerData data = new PlayerData(uuid, name, x, y, z, dimension, health, maxHealth, yaw);
        this.players.put(uuid, data);
    }

    public void removePlayer(UUID uuid) {
        this.players.remove(uuid);
    }

    public Collection<PlayerData> getPlayers() {
        return this.players.values();
    }

    public List<PlayerData> getPlayersInDimension(String dimension) {
        ArrayList<PlayerData> result = new ArrayList<PlayerData>();
        for (PlayerData player : this.players.values()) {
            if (!player.dimension.equals(dimension)) continue;
            result.add(player);
        }
        return result;
    }

    public void clearPlayers() {
        this.players.clear();
    }

    public boolean isLoadingChunks() {
        return this.isLoadingChunks;
    }

    public void setLoadingChunks(boolean loading) {
        this.isLoadingChunks = loading;
    }

    public int getLoadedChunks() {
        return this.loadedChunks;
    }

    public void setLoadedChunks(int loaded) {
        this.loadedChunks = loaded;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public void setTotalChunks(int total) {
        this.totalChunks = total;
    }

    public float getLoadingProgress() {
        if (this.totalChunks == 0) {
            return 1.0f;
        }
        return (float)this.loadedChunks / (float)this.totalChunks;
    }

    public static class PlayerData {
        public final UUID uuid;
        public final String name;
        public final double x;
        public final double y;
        public final double z;
        public final String dimension;
        public final double health;
        public final double maxHealth;
        public final float yaw;

        public PlayerData(UUID uuid, String name, double x, double y, double z, String dimension, double health, double maxHealth, float yaw) {
            this.uuid = uuid;
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimension = dimension;
            this.health = health;
            this.maxHealth = maxHealth;
            this.yaw = yaw;
        }

        public class_2338 getBlockPos() {
            return new class_2338((int)this.x, (int)this.y, (int)this.z);
        }

        public double getHealthPercentage() {
            return this.maxHealth > 0.0 ? this.health / this.maxHealth : 0.0;
        }

        public String toString() {
            return String.format("%s @ (%.1f, %.1f, %.1f) [%s] HP: %.1f/%.1f", this.name, this.x, this.y, this.z, this.dimension, this.health, this.maxHealth);
        }
    }
}

