/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.network;

import fr.kingsfall.minimap.AdvancedMinimapClient;
import fr.kingsfall.minimap.data.ChunkCache;
import fr.kingsfall.minimap.data.MinimapState;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ServerPacketHandler {
    private static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"kingsfall", (String)"minimap");

    public static void register() {
        PayloadTypeRegistry.playS2C().register(MinimapPayload.ID, MinimapPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(MinimapPayload.ID, (payload, context) -> ServerPacketHandler.handlePacket(payload.data()));
        System.out.println("[AdvancedMinimap] Packet handler enregistr\u00e9 pour le channel: " + String.valueOf(CHANNEL_ID));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handlePacket(byte[] data) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);
             DataInputStream dis = new DataInputStream(bais);){
            byte packetType = dis.readByte();
            switch (packetType) {
                case 0: {
                    ServerPacketHandler.handleChunkBatch(dis);
                    return;
                }
                case 1: {
                    ServerPacketHandler.handleSingleChunk(dis);
                    return;
                }
                case 2: {
                    ServerPacketHandler.handlePlayerData(dis);
                    return;
                }
                default: {
                    System.err.println("[AdvancedMinimap] Type de packet inconnu: " + packetType);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[AdvancedMinimap] Erreur lors du traitement du packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleChunkBatch(DataInputStream dis) throws Exception {
        String worldId = dis.readUTF();
        int chunkCount = dis.readInt();
        ChunkCache cache = AdvancedMinimapClient.getChunkCache();
        MinimapState.INSTANCE.setLoadingChunks(true);
        int currentLoaded = MinimapState.INSTANCE.getLoadedChunks();
        MinimapState.INSTANCE.setTotalChunks(MinimapState.INSTANCE.getTotalChunks() + chunkCount);
        for (int i = 0; i < chunkCount; ++i) {
            int chunkX = dis.readInt();
            int chunkZ = dis.readInt();
            byte[] colorData = new byte[256];
            dis.readFully(colorData);
            cache.putChunk(worldId, chunkX, chunkZ, colorData);
            MinimapState.INSTANCE.setLoadedChunks(currentLoaded + i + 1);
        }
        System.out.println(String.format("[AdvancedMinimap] Re\u00e7u %d chunks pour le monde %s (total: %d/%d)", chunkCount, worldId, MinimapState.INSTANCE.getLoadedChunks(), MinimapState.INSTANCE.getTotalChunks()));
        if (MinimapState.INSTANCE.getLoadedChunks() >= MinimapState.INSTANCE.getTotalChunks()) {
            MinimapState.INSTANCE.setLoadingChunks(false);
            System.out.println("[AdvancedMinimap] Chargement des chunks termin\u00e9 !");
            cache.saveDimensionCache(worldId);
        }
    }

    private static void handleSingleChunk(DataInputStream dis) throws Exception {
        String worldId = dis.readUTF();
        int chunkX = dis.readInt();
        int chunkZ = dis.readInt();
        byte[] colorData = new byte[256];
        dis.readFully(colorData);
        ChunkCache cache = AdvancedMinimapClient.getChunkCache();
        cache.putChunk(worldId, chunkX, chunkZ, colorData);
        System.out.println(String.format("[AdvancedMinimap] Chunk mis \u00e0 jour: %s @ (%d, %d)", worldId, chunkX, chunkZ));
    }

    private static void handlePlayerData(DataInputStream dis) throws Exception {
        int playerCount = dis.readInt();
        MinimapState state = MinimapState.INSTANCE;
        for (int i = 0; i < playerCount; ++i) {
            UUID uuid = UUID.fromString(dis.readUTF());
            String name = dis.readUTF();
            double x = dis.readDouble();
            double y = dis.readDouble();
            double z = dis.readDouble();
            String dimension = dis.readUTF();
            double health = dis.readDouble();
            double maxHealth = dis.readDouble();
            float yaw = dis.readFloat();
            state.updatePlayer(uuid, name, x, y, z, dimension, health, maxHealth, yaw);
        }
    }

    public record MinimapPayload(byte[] data) implements class_8710
    {
        public static final class_8710.class_9154<MinimapPayload> ID = new class_8710.class_9154(CHANNEL_ID);
        public static final class_9139<class_9129, MinimapPayload> CODEC = new class_9139<class_9129, MinimapPayload>(){

            public MinimapPayload decode(class_9129 buf) {
                byte[] data = new byte[buf.readableBytes()];
                buf.method_52979(data);
                return new MinimapPayload(data);
            }

            public void encode(class_9129 buf, MinimapPayload payload) {
                buf.method_52983(payload.data);
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

