/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.render;

import fr.kingsfall.minimap.AdvancedMinimapClient;
import fr.kingsfall.minimap.data.ChunkCache;
import fr.kingsfall.minimap.data.MinimapState;
import fr.kingsfall.minimap.util.ColorUtils;
import fr.kingsfall.minimap.util.RenderUtils;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9779;

public class MinimapHudRenderer {
    private static final int MINIMAP_SIZE = 150;
    private static final int MINIMAP_X = 10;
    private static final int MINIMAP_Y = 10;
    private static final int BORDER_COLOR = -1;
    private static final int BACKGROUND_COLOR = -15066598;

    public static void register() {
        HudRenderCallback.EVENT.register(MinimapHudRenderer::render);
        System.out.println("[AdvancedMinimap] HUD Renderer enregistr\u00e9");
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.method_1493() || !MinimapState.INSTANCE.isMinimapVisible()) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null || client.field_1687 == null) {
            return;
        }
        context.method_51448().pushMatrix();
        MinimapHudRenderer.renderMinimap(context, client, player);
        context.method_51448().popMatrix();
    }

    private static void renderMinimap(class_332 context, class_310 client, class_746 player) {
        int x = 10;
        int y = 10;
        int size = 150;
        RenderUtils.fillRect(context, x, y, size, size, -15066598);
        MinimapHudRenderer.renderChunks(context, client, player, x, y, size);
        MinimapHudRenderer.renderEntities(context, client, player, x, y, size);
        MinimapHudRenderer.renderPlayers(context, client, player, x, y, size);
        MinimapHudRenderer.renderCurrentPlayer(context, player, x + size / 2, y + size / 2);
        RenderUtils.drawBorder(context, x, y, size, size, -1);
        MinimapHudRenderer.renderInfo(context, client, player, x, y, size);
    }

    private static void renderChunks(class_332 context, class_310 client, class_746 player, int mapX, int mapY, int mapSize) {
        ChunkCache cache = AdvancedMinimapClient.getChunkCache();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        String dimensionId = world.method_27983().method_29177().toString();
        float zoom = MinimapState.INSTANCE.getZoomLevel();
        double playerX = player.method_23317();
        double playerZ = player.method_23321();
        int playerY = (int)player.method_23318();
        if (MinimapState.INSTANCE.isCaveModeEnabled()) {
            playerY = MinimapState.INSTANCE.getCaveLevel();
        }
        int renderRadius = (int)(8.0f / zoom);
        int centerChunkX = (int)(playerX / 16.0);
        int centerChunkZ = (int)(playerZ / 16.0);
        for (int dx = -renderRadius; dx <= renderRadius; ++dx) {
            for (int dz = -renderRadius; dz <= renderRadius; ++dz) {
                int chunkX = centerChunkX + dx;
                int chunkZ = centerChunkZ + dz;
                byte[] chunkData = cache.getChunk(dimensionId, chunkX, chunkZ);
                if (chunkData == null) continue;
                MinimapHudRenderer.renderChunkPixels(context, chunkData, chunkX, chunkZ, playerX, playerZ, playerY, zoom, mapX, mapY, mapSize);
            }
        }
    }

    private static void renderChunkPixels(class_332 context, byte[] chunkData, int chunkX, int chunkZ, double playerX, double playerZ, int playerY, float zoom, int mapX, int mapY, int mapSize) {
        int chunkWorldX = chunkX * 16;
        int chunkWorldZ = chunkZ * 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkWorldX + x;
                int blockZ = chunkWorldZ + z;
                double relX = ((double)blockX - playerX) * (double)zoom;
                double relZ = ((double)blockZ - playerZ) * (double)zoom;
                int screenX = mapX + mapSize / 2 + (int)relX;
                int screenY = mapY + mapSize / 2 + (int)relZ;
                if (screenX < mapX || screenX >= mapX + mapSize || screenY < mapY || screenY >= mapY + mapSize) continue;
                byte colorByte = chunkData[x * 16 + z];
                int color = ColorUtils.byteToARGB(colorByte);
                RenderUtils.drawPixel(context, screenX, screenY, color);
            }
        }
    }

    private static void renderEntities(class_332 context, class_310 client, class_746 player, int mapX, int mapY, int mapSize) {
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        float zoom = MinimapState.INSTANCE.getZoomLevel();
        int radius = 64;
        List entities = world.method_8335((class_1297)player, player.method_5829().method_1014((double)radius));
        for (class_1297 entity : entities) {
            int color;
            if (entity.method_5858((class_1297)player) > (double)(radius * radius)) continue;
            int size = 3;
            if (entity instanceof class_1588) {
                color = -65536;
            } else {
                if (!(entity instanceof class_1296)) continue;
                color = -16711936;
            }
            double relX = (entity.method_23317() - player.method_23317()) * (double)zoom;
            double relZ = (entity.method_23321() - player.method_23321()) * (double)zoom;
            int screenX = mapX + mapSize / 2 + (int)relX;
            int screenY = mapY + mapSize / 2 + (int)relZ;
            if (screenX < mapX || screenX >= mapX + mapSize || screenY < mapY || screenY >= mapY + mapSize) continue;
            RenderUtils.drawPoint(context, screenX, screenY, size, color);
        }
    }

    private static void renderPlayers(class_332 context, class_310 client, class_746 localPlayer, int mapX, int mapY, int mapSize) {
        if (client.field_1687 == null) {
            return;
        }
        String currentDimension = client.field_1687.method_27983().method_29177().toString();
        float zoom = MinimapState.INSTANCE.getZoomLevel();
        for (MinimapState.PlayerData playerData : MinimapState.INSTANCE.getPlayersInDimension(currentDimension)) {
            if (localPlayer.method_5667().equals(playerData.uuid)) continue;
            double relX = (playerData.x - localPlayer.method_23317()) * (double)zoom;
            double relZ = (playerData.z - localPlayer.method_23321()) * (double)zoom;
            int screenX = mapX + mapSize / 2 + (int)relX;
            int screenY = mapY + mapSize / 2 + (int)relZ;
            if (screenX < mapX - 20 || screenX >= mapX + mapSize + 20 || screenY < mapY - 20 || screenY >= mapY + mapSize + 20) continue;
            int playerSize = 6;
            int playerColor = -16737793;
            RenderUtils.fillRect(context, screenX - playerSize / 2, screenY - playerSize / 2, playerSize, playerSize, playerColor);
            RenderUtils.drawBorder(context, screenX - playerSize / 2, screenY - playerSize / 2, playerSize, playerSize, -1);
            RenderUtils.drawArrow(context, screenX, screenY, playerData.yaw, 8, -1);
            if (!(Math.abs(relX) < 50.0) || !(Math.abs(relZ) < 50.0)) continue;
            RenderUtils.drawCenteredText(context, playerData.name, screenX, screenY - 15, -1);
            int barWidth = 20;
            int barHeight = 3;
            float healthPercent = (float)playerData.getHealthPercentage();
            int healthColor = ColorUtils.healthToColor(healthPercent);
            RenderUtils.drawProgressBar(context, screenX - barWidth / 2, screenY + playerSize, barWidth, barHeight, healthPercent, -13421773, healthColor);
        }
    }

    private static void renderCurrentPlayer(class_332 context, class_746 player, int centerX, int centerY) {
        RenderUtils.drawArrow(context, centerX, centerY, player.method_36454(), 10, -256);
        RenderUtils.fillCircle(context, centerX, centerY, 2, -1);
    }

    private static void renderInfo(class_332 context, class_310 client, class_746 player, int mapX, int mapY, int mapSize) {
        int infoY = mapY + mapSize + 5;
        class_2338 pos = player.method_24515();
        String coords = String.format("XYZ: %d, %d, %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        RenderUtils.drawTextWithShadow(context, coords, mapX, infoY, -1);
        if (MinimapState.INSTANCE.isCaveModeEnabled()) {
            String caveMode = "Cave Y: " + MinimapState.INSTANCE.getCaveLevel();
            RenderUtils.drawTextWithShadow(context, caveMode, mapX, infoY + 10, -22016);
        }
        if (MinimapState.INSTANCE.isLoadingChunks()) {
            float progress = MinimapState.INSTANCE.getLoadingProgress();
            String loadingText = String.format("Loading: %.0f%%", Float.valueOf(progress * 100.0f));
            RenderUtils.drawTextWithShadow(context, loadingText, mapX, infoY + 20, -5570646);
            RenderUtils.drawProgressBar(context, mapX, infoY + 30, mapSize, 5, progress, -13421773, -16711936);
        }
    }
}

