/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.screen;

import fr.kingsfall.minimap.AdvancedMinimapClient;
import fr.kingsfall.minimap.data.ChunkCache;
import fr.kingsfall.minimap.data.MinimapState;
import fr.kingsfall.minimap.util.ColorUtils;
import fr.kingsfall.minimap.util.RenderUtils;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class FullscreenMapScreen
extends class_437 {
    private double offsetX = 0.0;
    private double offsetZ = 0.0;
    private float zoom = 1.0f;
    private boolean isDragging = false;
    private int lastMouseX = 0;
    private int lastMouseZ = 0;

    public FullscreenMapScreen() {
        super((class_2561)class_2561.method_43470((String)"Fullscreen Map"));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        this.renderMap(context, mouseX, mouseY);
        this.renderUI(context, mouseX, mouseY);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderMap(class_332 context, int mouseX, int mouseY) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null || this.field_22787.field_1687 == null) {
            return;
        }
        ChunkCache cache = AdvancedMinimapClient.getChunkCache();
        String dimensionId = this.field_22787.field_1687.method_27983().method_29177().toString();
        double playerX = this.field_22787.field_1724.method_23317();
        double playerZ = this.field_22787.field_1724.method_23321();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        double viewX = playerX + this.offsetX;
        double viewZ = playerZ + this.offsetZ;
        Map<class_1923, byte[]> chunks = cache.getAllChunks(dimensionId);
        for (Map.Entry<class_1923, byte[]> entry : chunks.entrySet()) {
            class_1923 chunkPos = entry.getKey();
            byte[] chunkData = entry.getValue();
            this.renderChunk(context, chunkData, chunkPos, viewX, viewZ, this.zoom, centerX, centerY);
        }
        this.renderPlayers(context, playerX, playerZ, viewX, viewZ, this.zoom, centerX, centerY);
        int playerScreenX = (int)((double)centerX + (playerX - viewX) * (double)this.zoom);
        int playerScreenY = (int)((double)centerY + (playerZ - viewZ) * (double)this.zoom);
        RenderUtils.drawArrow(context, playerScreenX, playerScreenY, this.field_22787.field_1724.method_36454(), 15, -256);
        RenderUtils.fillCircle(context, playerScreenX, playerScreenY, 3, -1);
        this.renderCursor(context, mouseX, mouseY, viewX, viewZ, this.zoom, centerX, centerY);
    }

    private void renderChunk(class_332 context, byte[] chunkData, class_1923 chunkPos, double viewX, double viewZ, float zoom, int centerX, int centerY) {
        int chunkWorldX = chunkPos.field_9181 * 16;
        int chunkWorldZ = chunkPos.field_9180 * 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int blockX = chunkWorldX + x;
                int blockZ = chunkWorldZ + z;
                double relX = ((double)blockX - viewX) * (double)zoom;
                double relZ = ((double)blockZ - viewZ) * (double)zoom;
                int screenX = centerX + (int)relX;
                int screenY = centerY + (int)relZ;
                if (screenX < 0 || screenX >= this.field_22789 || screenY < 0 || screenY >= this.field_22790) continue;
                byte colorByte = chunkData[x * 16 + z];
                int color = ColorUtils.byteToARGB(colorByte);
                RenderUtils.drawPixel(context, screenX, screenY, color);
            }
        }
    }

    private void renderPlayers(class_332 context, double playerX, double playerZ, double viewX, double viewZ, float zoom, int centerX, int centerY) {
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return;
        }
        String currentDimension = this.field_22787.field_1687.method_27983().method_29177().toString();
        for (MinimapState.PlayerData player : MinimapState.INSTANCE.getPlayersInDimension(currentDimension)) {
            if (this.field_22787.field_1724 != null && this.field_22787.field_1724.method_5667().equals(player.uuid)) continue;
            double relX = (player.x - viewX) * (double)zoom;
            double relZ = (player.z - viewZ) * (double)zoom;
            int screenX = centerX + (int)relX;
            int screenY = centerY + (int)relZ;
            if (screenX < -50 || screenX >= this.field_22789 + 50 || screenY < -50 || screenY >= this.field_22790 + 50) continue;
            int playerSize = 8;
            RenderUtils.fillRect(context, screenX - playerSize / 2, screenY - playerSize / 2, playerSize, playerSize, -16737793);
            RenderUtils.drawBorder(context, screenX - playerSize / 2, screenY - playerSize / 2, playerSize, playerSize, -1);
            RenderUtils.drawArrow(context, screenX, screenY, player.yaw, 12, -1);
            RenderUtils.drawCenteredText(context, player.name, screenX, screenY - 20, -1);
            int barWidth = 30;
            int barHeight = 4;
            float healthPercent = (float)player.getHealthPercentage();
            int healthColor = ColorUtils.healthToColor(healthPercent);
            RenderUtils.drawProgressBar(context, screenX - barWidth / 2, screenY + playerSize, barWidth, barHeight, healthPercent, -13421773, healthColor);
        }
    }

    private void renderCursor(class_332 context, int mouseX, int mouseY, double viewX, double viewZ, float zoom, int centerX, int centerY) {
        double worldX = viewX + (double)((float)(mouseX - centerX) / zoom);
        double worldZ = viewZ + (double)((float)(mouseY - centerY) / zoom);
        String coords = String.format("X: %d, Z: %d", (int)worldX, (int)worldZ);
        int textWidth = this.field_22793.method_1727(coords);
        RenderUtils.fillRect(context, mouseX + 10, mouseY - 15, textWidth + 6, 12, -872415232);
        RenderUtils.drawTextWithShadow(context, coords, mouseX + 13, mouseY - 13, -1);
    }

    private void renderUI(class_332 context, int mouseX, int mouseY) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        String title = "Carte du monde - Appuyez sur \u00c9chap pour fermer";
        RenderUtils.drawCenteredText(context, title, this.field_22789 / 2, 10, -1);
        String zoomText = String.format("Zoom: %.2fx", Float.valueOf(this.zoom));
        RenderUtils.drawTextWithShadow(context, zoomText, 10, this.field_22790 - 60, -1);
        class_2338 pos = this.field_22787.field_1724.method_24515();
        String playerPos = String.format("Position: %d, %d, %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        RenderUtils.drawTextWithShadow(context, playerPos, 10, this.field_22790 - 45, -1);
        String dimension = this.field_22787.field_1687.method_27983().method_29177().method_12832();
        RenderUtils.drawTextWithShadow(context, "Dimension: " + dimension, 10, this.field_22790 - 30, -1);
        RenderUtils.drawTextWithShadow(context, "Molette: Zoom", 10, this.field_22790 - 15, -5592406);
        RenderUtils.drawTextWithShadow(context, "Clic + Glisser: D\u00e9placer", 130, this.field_22790 - 15, -5592406);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        float oldZoom = this.zoom;
        this.zoom += (float)verticalAmount * 0.1f;
        this.zoom = Math.max(0.1f, Math.min(10.0f, this.zoom));
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.isDragging = true;
            this.offsetX -= deltaX / (double)this.zoom;
            this.offsetZ -= deltaY / (double)this.zoom;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = true;
            this.lastMouseX = (int)mouseX;
            this.lastMouseZ = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(null);
        }
    }
}

