/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.util;

public class ColorUtils {
    public static int byteToARGB(byte colorByte) {
        int color = colorByte & 0xFF;
        int r = (color >> 5 & 7) * 255 / 7;
        int g = (color >> 2 & 7) * 255 / 7;
        int b = (color & 3) * 255 / 3;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int blendColors(int color1, int color2, float ratio) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * (1.0f - ratio) + (float)a2 * ratio);
        int r = (int)((float)r1 * (1.0f - ratio) + (float)r2 * ratio);
        int g = (int)((float)g1 * (1.0f - ratio) + (float)g2 * ratio);
        int b = (int)((float)b1 * (1.0f - ratio) + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int darken(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int lighten(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * factor));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * factor));
        int b = Math.min(255, (int)((float)(color & 0xFF) * factor));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int toGrayscale(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int gray = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return a << 24 | gray << 16 | gray << 8 | gray;
    }

    public static int argb(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int rgb(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int healthToColor(float health) {
        if (health > 0.5f) {
            return ColorUtils.blendColors(-16711936, -256, (1.0f - health) * 2.0f);
        }
        return ColorUtils.blendColors(-256, -65536, (0.5f - health) * 2.0f);
    }
}

