/*
 * Decompiled with CFR 0.152.
 */
package fr.kingsfall.minimap.util;

import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class RenderUtils {
    public static void fillRect(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + height, color);
    }

    public static void drawRect(class_332 context, int x, int y, int width, int height, int color, int thickness) {
        RenderUtils.fillRect(context, x, y, width, thickness, color);
        RenderUtils.fillRect(context, x, y + height - thickness, width, thickness, color);
        RenderUtils.fillRect(context, x, y, thickness, height, color);
        RenderUtils.fillRect(context, x + width - thickness, y, thickness, height, color);
    }

    public static void drawBorder(class_332 context, int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(context, x, y, width, height, color, 1);
    }

    public static void fillCircle(class_332 context, int centerX, int centerY, int radius, int color) {
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                if (x * x + y * y > radius * radius) continue;
                RenderUtils.fillRect(context, centerX + x, centerY + y, 1, 1, color);
            }
        }
    }

    public static void drawPoint(class_332 context, int x, int y, int size, int color) {
        RenderUtils.fillRect(context, x - size / 2, y - size / 2, size, size, color);
    }

    public static void drawPixel(class_332 context, int x, int y, int color) {
        context.method_25294(x, y, x + 1, y + 1, color);
    }

    public static void drawArrow(class_332 context, int centerX, int centerY, float yaw, int size, int color) {
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)centerX, (float)centerY);
        float angleRadians = (float)Math.toRadians(yaw + 180.0f);
        context.method_51448().rotate(angleRadians);
        int halfSize = size / 2;
        int x1 = 0;
        int y1 = -halfSize;
        int x2 = -halfSize;
        int y2 = halfSize;
        int x3 = halfSize;
        int y3 = halfSize;
        RenderUtils.drawLine(context, x1, y1, x2, y2, color);
        RenderUtils.drawLine(context, x2, y2, x3, y3, color);
        RenderUtils.drawLine(context, x3, y3, x1, y1, color);
        for (int y = -halfSize; y <= halfSize; ++y) {
            int width = (int)(((double)halfSize - Math.abs((double)y + (double)halfSize / 3.0)) * 2.0);
            if (width <= 0) continue;
            RenderUtils.fillRect(context, -width / 2, y, width, 1, color);
        }
        context.method_51448().popMatrix();
    }

    public static void drawLine(class_332 context, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int x = x1;
        int y = y1;
        while (true) {
            RenderUtils.drawPixel(context, x, y, color);
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    public static void drawProgressBar(class_332 context, int x, int y, int width, int height, float progress, int backgroundColor, int foregroundColor) {
        RenderUtils.fillRect(context, x, y, width, height, backgroundColor);
        int progressWidth = (int)((float)width * Math.min(1.0f, Math.max(0.0f, progress)));
        RenderUtils.fillRect(context, x, y, progressWidth, height, foregroundColor);
        RenderUtils.drawBorder(context, x, y, width, height, -1);
    }

    public static void drawTextWithShadow(class_332 context, String text, int x, int y, int color) {
        context.method_51433(class_310.method_1551().field_1772, text, x, y, color, true);
    }

    public static void drawCenteredText(class_332 context, String text, int centerX, int y, int color) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int textWidth = textRenderer.method_1727(text);
        RenderUtils.drawTextWithShadow(context, text, centerX - textWidth / 2, y, color);
    }

    public static int applyAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        return a << 24 | color & 0xFFFFFF;
    }
}

